class FragOrDie extends Mutator config(FragOrDie);

var config int MaxHealth;
var config bool bRemoveArmor;

var bool Init;

function PostBeginPlay()
{
	if (Init)
		return;
	Init = True;

	Level.Game.RegisterDamageMutator(Self);

	settimer(1.0, true);
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	if ( Victim != none && Victim != InstigatedBy && InstigatedBy != none )
		{
		if ( InstigatedBy.IsA('PlayerPawn') || InstigatedBy.IsA('Bot'))
			{
			if ( ActualDamage > Victim.Health )
				{
				ActualDamage = Victim.Health;
				}
			InstigatedBy.Health += ActualDamage;
			if ( InstigatedBy.Health > MaxHealth )
				{
				InstigatedBy.Health = MaxHealth;
				}
			}
		}

	if ( NextDamageMutator != None )
     		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

function Timer()
{
	TakeHealth();
}

function TakeHealth()
{
local Pawn P;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn'))
			{
			PlayerPawn(P).Health--;
			}
		else if (P.IsA('Bot'))
			{	
			Bot(P).Health--;
			}
		
		}
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
if (bRemoveArmor)
	{
	if (Other.IsA('TournamentHealth') || Other.IsA('Armor2') || Other.IsA('ThighPads') || Other.IsA('UT_ShieldBelt'))
		{
		return false;
		}
	}	
return true;
}

defaultproperties
{
}
